<?php

namespace App\Models;

use CodeIgniter\Model;

class TrainingModel extends Model
{
    protected $table            = 'training';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = [
        'nama_pelatihan', 'penyelenggara', 'tanggal_mulai', 'tanggal_selesai',
        'deskripsi', 'sertifikat', 'urutan', 'created_at', 'updated_at'
    ];

    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    public function searchAndFilter($search = '', $filter = [], $sort = 'urutan', $order = 'ASC')
    {
        $builder = $this->builder();

        if (!empty($search)) {
            $builder->groupStart()
                ->like('nama_pelatihan', $search)
                ->orLike('penyelenggara', $search)
                ->orLike('deskripsi', $search)
                ->groupEnd();
        }

        if (!empty($filter['penyelenggara'])) {
            $builder->where('penyelenggara', $filter['penyelenggara']);
        }

        if (!empty($filter['tanggal_mulai'])) {
            $builder->where('tanggal_mulai >=', $filter['tanggal_mulai']);
        }

        if (!empty($filter['tanggal_selesai'])) {
            $builder->where('tanggal_selesai <=', $filter['tanggal_selesai']);
        }

        $allowedSorts = ['urutan', 'nama_pelatihan', 'penyelenggara', 'tanggal_mulai', 'tanggal_selesai'];
        $sort = in_array($sort, $allowedSorts) ? $sort : 'urutan';
        $order = strtoupper($order) === 'DESC' ? 'DESC' : 'ASC';

        $builder->orderBy($sort, $order);

        return $builder;
    }
}


